/*
 * Decompiled with CFR 0.152.
 */
package si.matjazcerkvenik.ftpsync;

import org.apache.commons.vfs2.FileChangeEvent;
import org.apache.commons.vfs2.FileListener;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.impl.DefaultFileMonitor;
import si.matjazcerkvenik.ftpsync.FtpTransfer;
import si.matjazcerkvenik.ftpsync.Util;

public class WatchThread
implements FileListener {
    private FileSystemManager manager;
    private FileObject file;
    private DefaultFileMonitor fm = new DefaultFileMonitor(this);

    public void start() {
        try {
            this.manager = VFS.getManager();
            this.file = this.manager.resolveFile(Util.SYNC_SOURCE);
        }
        catch (FileSystemException e) {
            e.printStackTrace();
        }
        this.fm.setDelay(Util.getSyncInterval() * 1000);
        this.fm.setRecursive(true);
        this.fm.addFile(this.file);
        this.fm.start();
        while (true) {
            try {
                while (true) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    @Override
    public void fileChanged(FileChangeEvent arg0) throws Exception {
        String file = arg0.getFile().getURL().toString();
        FtpTransfer.upload(file);
    }

    @Override
    public void fileCreated(FileChangeEvent arg0) throws Exception {
        String file = arg0.getFile().getURL().toString();
        FtpTransfer.upload(file);
    }

    @Override
    public void fileDeleted(FileChangeEvent arg0) throws Exception {
        String file = arg0.getFile().getURL().toString();
        FtpTransfer.delete(file);
    }
}

