/*
 * Decompiled with CFR 0.152.
 */
package si.matjazcerkvenik.openmp3player.starter;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import si.matjazcerkvenik.openmp3player.starter.Start;
import si.matjazcerkvenik.openmp3player.starter.Updater;

public class Gui
extends JFrame {
    private static final long serialVersionUID = 2781903683927171982L;
    private JLabel lblTitle = new JLabel("OpenMp3Player");
    private JLabel lblStatus = new JLabel("Status: Stopped");
    private JButton btnStartStop = new JButton("Start server");
    private JButton btnUpdate = new JButton("Update");
    private JPanel pnlControls = new JPanel();
    private Updater u = new Updater();

    public Gui() {
        super("Starter");
        this.pnlControls.setLayout(new GridLayout(4, 1));
        this.lblTitle.setText("OpenMp3Player v" + Start.version);
        this.pnlControls.add(this.lblTitle);
        this.pnlControls.add(this.lblStatus);
        this.pnlControls.add(this.btnStartStop);
        this.pnlControls.add(this.btnUpdate);
        if (Start.isServerRunning()) {
            this.lblStatus.setText("Status: Running");
            this.btnStartStop.setText("Stop server");
        }
        if (!Start.isServerRunning() && this.u.isUpdateRequired()) {
            this.btnUpdate.setEnabled(true);
        } else {
            this.btnUpdate.setEnabled(false);
        }
        this.add(this.pnlControls);
        this.setDefaultCloseOperation(3);
        this.btnStartStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.startStopTomcat();
            }
        });
        this.btnUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.u.updateOmp3p();
                Start.version = Updater.lastVersion;
                Gui.this.lblTitle.setText("OpenMp3Player v" + Start.version);
                Gui.this.btnUpdate.setEnabled(false);
            }
        });
    }

    private void startStopTomcat() {
        if (Start.isServerRunning()) {
            Start.stopServer();
            this.lblStatus.setText("Status: Stopped");
            this.btnStartStop.setText("Start server");
            if (this.u.isUpdateRequired()) {
                this.btnUpdate.setEnabled(true);
            } else {
                this.btnUpdate.setEnabled(false);
            }
        } else {
            Start.startServer();
            this.lblStatus.setText("Status: Running");
            this.btnStartStop.setText("Stop server");
            this.btnUpdate.setEnabled(false);
        }
    }
}

