/*
 * Decompiled with CFR 0.152.
 */
package si.matjazcerkvenik.openmp3player.starter;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import si.matjazcerkvenik.openmp3player.starter.Executor;
import si.matjazcerkvenik.openmp3player.starter.Gui;

public class Start {
    public static String[] startServerCommandX = new String[]{"./server/apache-tomcat-7.0.57/bin/startup.sh"};
    public static String[] stopServerCommandX = new String[]{"./server/apache-tomcat-7.0.57/bin/shutdown.sh"};
    public static String[] startServerCommandWin = new String[]{"cmd.exe", "/c", "set", "\"CATALINA_HOME=%cd%/server/apache-tomcat-7.0.57\"", "&", "START", "/B", "call", "server/apache-tomcat-7.0.57/bin/startup.bat"};
    public static String[] stopServerCommandWin = new String[]{"cmd.exe", "/c", "set", "\"CATALINA_HOME=%cd%/server/apache-tomcat-7.0.57\"", "&", "START", "/B", "call", "server/apache-tomcat-7.0.57/bin/shutdown.bat"};
    public static String version = "0.0.0";

    public static void main(String[] stringArray) {
        Start.init();
        if (stringArray.length > 0) {
            if (stringArray[0].equalsIgnoreCase("start")) {
                if (!Start.isServerRunning()) {
                    Start.startServer();
                }
                System.out.println("Started");
            } else if (stringArray[0].equalsIgnoreCase("stop")) {
                if (Start.isServerRunning()) {
                    Start.stopServer();
                }
                System.out.println("Stopped");
            } else if (stringArray[0].equalsIgnoreCase("status")) {
                if (Start.isServerRunning()) {
                    System.out.println("Stopped");
                } else {
                    System.out.println("Started");
                }
            }
        } else {
            Gui gui = new Gui();
            gui.pack();
            gui.setVisible(true);
        }
    }

    public static void init() {
        Start.readVersion();
        if (Start.getOsType().endsWith("X")) {
            String[] stringArray = new String[]{"find", ".", "-name", "*.sh", "-exec", "chmod", "755", "{}", "+"};
            Executor executor = new Executor();
            executor.execute(stringArray, false);
        }
    }

    public static void startServer() {
        Executor executor = new Executor();
        if (Start.getOsType().endsWith("X")) {
            executor.execute(startServerCommandX, false);
        } else {
            executor.execute(startServerCommandWin, true);
        }
        Start.createRunningFile();
    }

    public static void stopServer() {
        Executor executor = new Executor();
        if (Start.getOsType().endsWith("X")) {
            executor.execute(stopServerCommandX, false);
        } else {
            executor.execute(stopServerCommandWin, true);
        }
        Start.removeRunningFile();
    }

    public static void createRunningFile() {
        File file = new File("config/running.tmp");
        try {
            file.createNewFile();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static boolean isServerRunning() {
        File file = new File("config/running.tmp");
        return file.exists();
    }

    public static void removeRunningFile() {
        File file = new File("config/running.tmp");
        file.delete();
    }

    public static String getOsType() {
        String string = System.getProperty("os.name");
        if (string.equalsIgnoreCase("Mac os X")) {
            return "OSX";
        }
        if (string.equalsIgnoreCase("Linux")) {
            return "LINUX";
        }
        if (string.contains("Windows")) {
            return "WINDOWS";
        }
        return "X";
    }

    private static void readVersion() {
        String string = "0.0.0";
        try {
            FileInputStream fileInputStream = new FileInputStream("config/version.txt");
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(dataInputStream));
            string = bufferedReader.readLine();
            dataInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        version = string;
    }
}

