/*
 * Decompiled with CFR 0.152.
 */
package si.matjazcerkvenik.openmp3player.starter;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import si.matjazcerkvenik.openmp3player.starter.Start;

public class Updater {
    private static String url = "http://www.matjazcerkvenik.si/projects/openmp3player/getLastVersion.php";
    public static String lastVersion = "0.0.0";

    public Updater() {
        this.getLastVersion();
    }

    public void updateOmp3p() {
        this.deleteDirectory(new File("server/apache-tomcat-7.0.57/work/Catalina/localhost/OpenMp3Player"));
        this.deleteDirectory(new File("server/apache-tomcat-7.0.57/webapps/OpenMp3Player"));
        this.deleteFile(new File("server/apache-tomcat-7.0.57/webapps/OpenMp3Player.war"));
        this.downloadWar();
        this.updateVersion();
    }

    private void getLastVersion() {
        try {
            String string;
            InputStream inputStream = new URL(url).openStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuffer stringBuffer = new StringBuffer();
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string);
            }
            bufferedReader.close();
            System.out.println(stringBuffer.toString());
            lastVersion = stringBuffer.toString();
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("MalformedURLException");
            malformedURLException.printStackTrace();
        }
        catch (IOException iOException) {
            System.out.println("IOException");
            iOException.printStackTrace();
        }
    }

    public boolean isUpdateRequired() {
        if (Start.version.contains("alpha") || Start.version.contains("beta")) {
            return false;
        }
        if (Start.version.equals(lastVersion)) {
            return false;
        }
        String[] stringArray = Start.version.split("\\.");
        String[] stringArray2 = lastVersion.split("\\.");
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        nArray[0] = Integer.parseInt(stringArray[0]);
        nArray[1] = Integer.parseInt(stringArray[1]);
        nArray[2] = Integer.parseInt(stringArray[2]);
        nArray2[0] = Integer.parseInt(stringArray2[0]);
        nArray2[1] = Integer.parseInt(stringArray2[1]);
        nArray2[2] = Integer.parseInt(stringArray2[2]);
        if (nArray[0] < nArray2[0]) {
            return true;
        }
        if (nArray[1] < nArray2[1]) {
            return true;
        }
        return nArray[2] < nArray2[2];
    }

    private boolean deleteDirectory(File file) {
        File[] fileArray;
        if (file.exists() && null != (fileArray = file.listFiles())) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    this.deleteDirectory(fileArray[i]);
                    continue;
                }
                fileArray[i].delete();
            }
        }
        return file.delete();
    }

    private boolean deleteFile(File file) {
        if (file.exists()) {
            return file.delete();
        }
        return false;
    }

    private void downloadWar() {
        try {
            ReadableByteChannel readableByteChannel = Channels.newChannel(new URL("http://www.matjazcerkvenik.si/projects/download/OpenMp3Player/" + lastVersion + "/OpenMp3Player.war").openStream());
            FileOutputStream fileOutputStream = new FileOutputStream("server/apache-tomcat-7.0.57/webapps/OpenMp3Player.war");
            FileChannel fileChannel = fileOutputStream.getChannel();
            fileChannel.transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
            fileChannel.close();
            fileOutputStream.close();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void updateVersion() {
        try {
            FileWriter fileWriter = new FileWriter("config/version.txt");
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(lastVersion);
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

