/*
 * Decompiled with CFR 0.152.
 */
package si.matjazcerkvenik.simplelogger;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import si.matjazcerkvenik.simplelogger.SimpleLogger;

public class LogWriter {
    private SimpleLogger logger = null;
    private File f = null;
    private FileWriter fwStream = null;
    private BufferedWriter out = null;
    private PrintWriter pw = null;
    private long maxSize = 0x100008L;

    public LogWriter(SimpleLogger logger) {
        this.logger = logger;
    }

    private void initLogger() {
        if (this.fwStream != null) {
            return;
        }
        this.f = new File(this.logger.getFilename());
        if (this.f.exists()) {
            if (this.logger.isAppend()) {
                System.out.println("[SimpleLogger] Append output to: " + this.logger.getFilename());
            }
        } else {
            try {
                this.f.createNewFile();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        try {
            this.fwStream = new FileWriter(this.logger.getFilename(), this.logger.isAppend());
            this.pw = new PrintWriter(this.fwStream);
        }
        catch (IOException e) {
            System.err.println("Writing exception");
        }
        this.out = new BufferedWriter(this.fwStream);
    }

    public synchronized void writeToFile(int level, String s, Throwable t) {
        if (this.fwStream == null) {
            this.initLogger();
        }
        try {
            if (t != null) {
                t.printStackTrace(this.pw);
                if (this.logger.isVerbose()) {
                    t.printStackTrace();
                }
            } else {
                String str = this.getDate() + " - " + this.getLevel(level) + " " + s;
                this.out.write(str + "\n");
                if (this.logger.isVerbose()) {
                    System.out.println(str);
                }
            }
            this.out.flush();
            if (this.f.length() > this.maxSize) {
                this.startNewLog();
            }
        }
        catch (IOException e) {
            System.out.println("IOException: write");
        }
    }

    private void startNewLog() {
        this.closeLogger();
        this.renameAll();
        this.initLogger();
    }

    private void renameAll() {
        File lastFile = new File(this.logger.getFilename() + "." + this.logger.getBackup());
        if (lastFile.exists()) {
            lastFile.delete();
        }
        for (int i = this.logger.getBackup() - 1; i > 0; --i) {
            File file = new File(this.logger.getFilename() + "." + i);
            if (!file.exists()) continue;
            File newFile = new File(this.logger.getFilename() + "." + (i + 1));
            file.renameTo(newFile);
        }
        File firstFile = new File(this.logger.getFilename());
        if (firstFile.exists()) {
            File newFile = new File(this.logger.getFilename() + "." + 1);
            firstFile.renameTo(newFile);
        }
    }

    public void closeLogger() {
        try {
            this.out.close();
            this.out = null;
            this.fwStream.close();
            this.fwStream = null;
        }
        catch (IOException e) {
            System.out.println("IOException: close");
        }
    }

    private String getLevel(int level) {
        if (level == 1) {
            return "TRACE";
        }
        if (level == 2) {
            return "DEBUG";
        }
        if (level == 3) {
            return "INFO ";
        }
        if (level == 4) {
            return "WARN ";
        }
        if (level == 5) {
            return "ERROR";
        }
        if (level == 6) {
            return "FATAL";
        }
        return "-";
    }

    private String getDate() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(this.logger.getDateFormat());
        return sdf.format(cal.getTime());
    }

    public void setMaxSize(int maxSizeMb) {
        this.maxSize *= (long)maxSizeMb;
    }
}

