/*
 * Decompiled with CFR 0.152.
 */
package si.matjazcerkvenik.simplelogger;

import java.util.Properties;
import si.matjazcerkvenik.simplelogger.LogWriter;

public class SimpleLogger {
    private boolean append = true;
    private int logLevel = 3;
    private String dateFormat = "yyyy.MM.dd hh:mm:ss:SSS";
    private String filename = "./simple-logger.log";
    private int maxSizeMb = 10;
    private int backup = 5;
    private boolean verbose = false;
    private LogWriter writer = null;

    public SimpleLogger() {
        this.writer = new LogWriter(this);
    }

    public SimpleLogger(String filename) {
        this.filename = filename;
        this.writer = new LogWriter(this);
    }

    public SimpleLogger(Properties props) {
        if (props.getProperty("simplelogger.filename") != null) {
            this.filename = props.getProperty("simplelogger.filename");
        }
        if (props.getProperty("simplelogger.level") != null) {
            String level = props.getProperty("simplelogger.level");
            this.logLevel = level.equalsIgnoreCase("trace") ? 1 : (level.equalsIgnoreCase("debug") ? 2 : (level.equalsIgnoreCase("info") ? 3 : (level.equalsIgnoreCase("warn") ? 4 : (level.equalsIgnoreCase("error") ? 5 : (level.equalsIgnoreCase("fatal") ? 6 : 3)))));
        }
        if (props.getProperty("simplelogger.append") != null && props.getProperty("simplelogger.append").equalsIgnoreCase("true")) {
            this.append = true;
        }
        if (props.getProperty("simplelogger.verbose") != null && props.getProperty("simplelogger.verbose").equalsIgnoreCase("true")) {
            this.verbose = true;
        }
        if (props.getProperty("simplelogger.maxFileSize") != null) {
            try {
                this.maxSizeMb = Integer.parseInt(props.getProperty("simplelogger.maxFileSize"));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (props.getProperty("simplelogger.maxBackupFiles") != null) {
            try {
                this.backup = Integer.parseInt(props.getProperty("simplelogger.maxBackupFiles"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (props.getProperty("simplelogger.dateFormat") != null) {
            this.dateFormat = props.getProperty("simplelogger.dateFormat");
        }
        this.writer = new LogWriter(this);
    }

    public void trace(String s) {
        if (this.logLevel - 1 < 1) {
            this.writer.writeToFile(1, s, null);
        }
    }

    public void trace(String s, Throwable t) {
        if (this.logLevel - 1 < 1) {
            this.writer.writeToFile(1, s, t);
        }
    }

    public void debug(String s) {
        if (this.logLevel - 1 < 2) {
            this.writer.writeToFile(2, s, null);
        }
    }

    public void debug(String s, Throwable t) {
        if (this.logLevel - 1 < 2) {
            this.writer.writeToFile(2, s, t);
        }
    }

    public void info(String s) {
        if (this.logLevel - 1 < 3) {
            this.writer.writeToFile(3, s, null);
        }
    }

    public void info(String s, Throwable t) {
        if (this.logLevel - 1 < 3) {
            this.writer.writeToFile(3, s, t);
        }
    }

    public void warn(String s) {
        if (this.logLevel - 1 < 4) {
            this.writer.writeToFile(4, s, null);
        }
    }

    public void warn(String s, Throwable t) {
        if (this.logLevel - 1 < 4) {
            this.writer.writeToFile(4, s, t);
        }
    }

    public void error(String s) {
        if (this.logLevel - 1 < 5) {
            this.writer.writeToFile(5, s, null);
        }
    }

    public void error(String s, Throwable t) {
        if (this.logLevel - 1 < 5) {
            this.writer.writeToFile(5, s, t);
        }
    }

    public void fatal(String s) {
        if (this.logLevel - 1 < 6) {
            this.writer.writeToFile(6, s, null);
        }
    }

    public void fatal(String s, Throwable t) {
        if (this.logLevel - 1 < 6) {
            this.writer.writeToFile(6, s, t);
        }
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public int getMaxSizeMb() {
        return this.maxSizeMb;
    }

    public void setMaxSizeMb(int maxSizeMb) {
        this.maxSizeMb = maxSizeMb;
        this.writer.setMaxSize(maxSizeMb);
    }

    public int getBackup() {
        return this.backup;
    }

    public void setBackup(int backup) {
        this.backup = backup;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void close() {
        this.writer.closeLogger();
    }
}

